class sysconfig::params {

    $db_name = hiera('sysconfig::params::db_name','corpus')
    $db_drpl_name = hiera('sysconfig::params::db_drpl_name','corpusdelaparole')
    $db_user = hiera('sysconfig::params::db_user','corpus_user')
    $db_pw   = hiera('sysconfig::params::db_pw','corpus')
    $db_host = hiera('sysconfig::params::db_host','127.0.0.1')
    $db_port = hiera('sysconfig::params::db_port','3306')

    $rdf4j_host = hiera('sysconfig::params::rdf4j_host', '127.0.0.1')
    $rdf4j_port = hiera('sysconfig::params::rdf4j_port', '8080')

    $es_host     = hiera('sysconfig::params::es_host', '127.0.0.1')
    $es_port     = hiera('sysconfig::params::es_port', '9200')
    $es_instance = hiera('sysconfig::params::es_instance', 'es_01')

    $hdl_host           = hiera('sysconfig::params::hdl_host', $::ipaddress)
    $hdl_user           = hiera('sysconfig::params::hdl_user', 'handle')
    $hdl_srv_port       = hiera('sysconfig::params::hdl_srv_port', '2641')
    $hdl_web_port       = hiera('sysconfig::params::hdl_web_port', '8000')
    $hdl_key_pswd       = hiera('sysconfig::params::hdl_key_pswd', 'corpus')
    $hdl_prefix         = hiera('sysconfig::params::hdl_prefix', '12345')
    $hdl_test_prefix    = hiera('sysconfig::params::hdl_test_prefix', '12345.1')
    $hdl_prefix_admin   = hiera('sysconfig::params::hdl_prefix_admin', 'CORPUS_ADMIN')
    $hdl_db_name        = hiera('sysconfig::params::hdl_db_name', 'handle')

    $tomcat_open_port = hiera('sysconfig::params::tomcat_open_port', false)

    $vhost = hiera('sysconfig::params::vhost', $::ipaddress)

    $memcached_max_memory = hiera('sysconfig::params::memcached_max_memory','25%')

    $corpus_app_key = hiera('sysconfig::params::corpus_app_key', 'TO_BE_DEFINED')

    $geonames_username = hiera('sysconfig::params::geonames_username', 'demo')

}
