<?php

namespace CorpusParole\Http\Controllers\Api;

// use CorpusParole\Http\Requests;
use CorpusParole\Http\Controllers\Controller;

use Illuminate\Http\Request;
use EasyRdf\Resource;
use EasyRdf\Literal;

use CorpusParole\Libraries\Sparql\SparqlClient;
use CorpusParole\Services\LexvoResolverInterface;
use CorpusParole\Services\BnfResolverInterface;


class DiscourseController extends Controller
{
    private $sparqlClient = null;

    public function __construct(SparqlClient $sparqlClient) {
        $this->sparqlClient = $sparqlClient;
    }

    /**
     * Display the specified resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        $query =  preg_replace('/\s+/', ' ', "SELECT (?o AS ?res) (COUNT(?s) AS ?count) WHERE {
            ?s a <http://www.europeana.eu/schemas/edm/ProvidedCHO>.
            ?s <http://purl.org/dc/elements/1.1/type> ?o.
            FILTER(uri(?o) in (<".implode('>,<', array_keys(config('corpusparole.corpus_discourse_type'))).">))
        }
        GROUP BY ?o
        ORDER BY DESC(?count)");

        $docs = $this->sparqlClient->query($query);

        $discourses = [];

        foreach ($docs as $row) {
            $key = $row->res->getUri();
            $count = $row->count->getValue();
            $label = config('corpusparole.corpus_discourse_type')[$key];
            $discourses[$key] = [
                "label" => $label,
                "count" => $count
            ];
        }

        return response()->json(['discourses' => $discourses ]);

    }

}
