import Ember from 'ember';

export default Ember.Component.extend({
  classNames: ['player-component'],
  currentTime: "00:00",
  duration: "00:00",

  _soundChanged: Ember.observer('sound', function() {
    this.pause();
    this.changeTime(0);
    this.updateProgress(0);
    this.audio.src = this.get("sound").get("master");
    this.audio.load();
    this.set("currentTime", "00:00");
  }),

  didInsertElement: function(){
    var _this = this;

    this.audio = new Audio("http://stop.com.pk/file/music_folder/700.mp3");

    this.button = {
      play: this.$('#action_play'),
      progress: this.$('.progress')
    };

		this.$(document).on('touchmove', function(e){
			e.preventDefault();
		});

		// seeker
		this.button.progress.on('mousedown', function(e){
			var r = _this.rotation(e.pageX, e.pageY);
			_this.updateProgress(r);
			_this.changeTime(r/360*100);
		});

    this.audio.addEventListener('loadedmetadata',function (){
      var minutes = Math.floor( _this.audio.duration / 60);
      var seconds =  Math.floor(_this.audio.duration) % 60;
      _this.set('duration', ('0' + minutes).slice(-2)+':'+('0' + seconds).slice(-2));
    });

		// update bar onchange
		this.audio.addEventListener('timeupdate',function (){
			var curtime = _this.audio.currentTime,
				percent = (curtime/_this.audio.duration)*100,
				deg = 360/100*percent,
        minutes = Math.floor( curtime / 60),
        seconds =  Math.floor(curtime) % 60;
      _this.set('currentTime', ('0' + minutes).slice(-2)+':'+('0' + seconds).slice(-2));
			_this.updateProgress(deg);
		});

		// when the audio has finished playing
		this.audio.addEventListener('ended', function(){
      _this.pause();
      _this.changeTime(0);
      _this.updateProgress(0);
		});
  },
  // change seeked time
  changeTime: function(percent){
    var t = (this.audio.duration*percent)/100;
    this.audio.currentTime = t;
  },
  updateProgress: function(deg){
    var $slice = this.$('.slice');

    if (deg > 180 && !$slice.is('.gt50')) {
      $slice.addClass('gt50');
      $slice.append('<div class="pie fill"></div>');
    } else if (deg < 180 && $slice.is('.gt50')) {
      $slice.removeClass('gt50');
      $slice.find('.fill').remove();
    }

    $slice.find('.pie').css({
      '-moz-transform':'rotate('+deg+'deg)',
      '-webkit-transform':'rotate('+deg+'deg)',
      '-o-transform':'rotate('+deg+'deg)',
      'transform':'rotate('+deg+'deg)'
    });
  },
  rotation: function(x,y){
    var offset = this.button.progress.offset();
    var button_centerX = (offset.left) + (this.button.progress.width()/2);
    var button_centerY = (offset.top) + (this.button.progress.height()/2);

    var radians = Math.atan2(x - button_centerX, y - button_centerY);
    var degree = Math.round( (radians * (180 / Math.PI) * -1) + 180 );
    return degree;
    //return (degree <= max ? degree : max);
  },
  play: function(){
    this.audio.play();
    this.button.play.addClass('playing');
    this.button.play.text('Pause');
  },
  pause: function(){
    this.audio.pause();
    this.button.play.removeClass('playing');
    this.button.play.text('Play');
  },
  actions: {
    tooglePlay: function(){
      if (this.button.play.is('.playing')) {
        this.pause();
      } else {
        this.play();
      }
    },
    prevNextSong(change){
      this.sendAction("action", change);
    }
  }
});
