import Ember from 'ember';
import AmCharts from 'ammaps';

export default Ember.Component.extend({

    continentsMapVar: AmCharts.maps.continentsLow,
    countriesMapVar: AmCharts.maps.worldLow,
    franceMapVar: AmCharts.maps.france2016Low,

    filter: Ember.inject.service(),
    locationObserver: Ember.observer('filter.location', function() {
        if(!this.get('filter').get('location')) {
            this.get('map').selectObject();
        }
    }),

    geostats: [],
    observerGeostats: Ember.observer('geostats', function() {
        //console.log(this.get('geostats'));
    }),

    didInsertElement: function(){
        this.$('#mapdiv').height(Ember.$('.corpus-app-container').height());
        this.createAmMap();
    },

    createAmMap: function() {
        var self = this;

        var france2016LowAreas = [];
        this.get('franceMapVar')['svg']['g']['path'].forEach(function(area) {
            france2016LowAreas.push({
                'id': area.id,
                'passZoomValuesToTarget': false,
                'autoZoom': false,
                'selectable': true
            })
        });

        var continentsLowAreas = [];
        this.get('continentsMapVar')['svg']['g']['path'].forEach(function(area) {
            var object = {
                'id': area.id,
                'linkToObject': {
                    'mapVar': self.get('countriesMapVar'),
                    'getAreasFromMap': true
                },
                'passZoomValuesToTarget': true,
                'autoZoom': true
            };
            if(area.id === 'europe') {
                object['linkToObject']['areas'] = [{
                    'id': 'FR',
                    'linkToObject': {
                        'mapVar': self.get('franceMapVar'),
                        'getAreasFromMap': true,
                        'areas': france2016LowAreas
                    },
                    'autoZoom': true,
                    'selectable': true
                }];
            }
            continentsLowAreas.push(object);
        });

        this.set('map', AmCharts.makeChart('mapdiv', {
            'type': 'map',
            'fontFamily': 'sans-serif',
            'fontSize': '12px',
            'dragMap': false,
            'zoomOnDoubleClick': false,
            'language': 'fr',

            'areasSettings': {
                'autoZoom': false,
                'selectable': true,
                'color': '#becfd4',
                'colorOutline': '#253946',
                'selectedColor': '#253946',
                'rollOverOutlineColor': '#253946'
            },

            'zoomControl': {
                'zoomControlEnabled': false,
            },

            'dataProvider': {
                'mapVar': this.get('continentsMapVar'),
                'areas': continentsLowAreas
            },

            listeners: [{
                'event':'clickMapObject',
                'method': Ember.run.bind(this, 'clickMapObject')
            },
            {
                'event':'homeButtonClicked',
                'method': Ember.run.bind(this, 'homeButtonClicked')
            }]
        }));
    },

    clickMapObject: function(event) {
        this.get('filter').set('location', event.mapObject.title);

        /*this.get('geostats').forEach( function (geostat) {
            console.log('geostat', geostat.get('id'), geostat.get('count'));
        });*/
    },

    homeButtonClicked: function(event) {
        if(event.chart.dataProvider.map !== 'continentsLow') {
            this.createAmMap();
        }
    }

});
