#!/bin/sh
#
clear
TARFILE=sources.tar.gz
DUMP=corpusdelaparole.sql     
APUSER=apache                                                                                                                             
APGROUP=apache                                                                                                                             
# Variables de configuration à modifier selon vos besoins
#########################################################                                                                                                                  
ROOT=/var/www/corpusdelaparole/drupal
DBNAME=corpusdelaparole
DBUSER=corpus
DBPASS=aeTh3ohC
DBSERV=127.0.0.1
PHP=/opt/remi/php56/root/usr/bin/php
#########################################################
splashTitle() {
cat <<"EOT"
                __ _   _____                         _    _____      _                                       
               / _(_) |  __ \                       | |  / ____|    | |                                      
          __ _| |_ _  | |  | |_ __ _   _ _ __   __ _| | | (___   ___| |_ _   _ _ __                          
         / _` |  _| | | |  | | '__| | | | '_ \ / _` | |  \___ \ / _ \ __| | | | '_ \                         
        | (_| | | | | | |__| | |  | |_| | |_) | (_| | |  ____) |  __/ |_| |_| | |_) |                        
         \__, |_| |_| |_____/|_|   \__,_| .__/ \__,_|_| |_____/ \___|\__|\__,_| .__/                         
          __/ |                         | |                                   | |                            
         |___/                          |_|                                   |_|                            
                                                                                                             
EOT
}

splashTitle
echo "--------------------------- PARAMETRES D'INSTALLATION -------------------------------------------------------"
echo "-------------------------------------------------------------------------------------------------------------"
echo "Dossier d'installation    = $ROOT"
echo "chemin php                = $PHP"
echo "Nom de la base de données = $DBNAME"
echo "User Mysql                = $DBUSER"
echo "Mot de passe Mysql        = $DBPASS"
echo "Serveur Mysql             = $DBSERV"
echo "-------------------------------------------------------------------------------------------------------------"
echo "-------------------------------------------------------------------------------------------------------------"
read -r -p "Etes-vous sur(e) de vouloir installer avec les paramètres ci dessus ? [Oui/n]" response
 response=${response,,} # tolower
 if [[ $response =~ ^(oui|o| ) ]]; then 	
	#
	echo ""
	echo ""
	echo "-------------------- Installation du site corpus de la parole -----------------------------------------------"
	echo "-------------------------------------------------------------------------------------------------------------"
	#                                                                                                                                                     
	# Errors are fatal
	#                                                                                                                                                     
	set -e

	echo ""
	echo "Copie des sources et du dump SQL dans $ROOT"
	echo "-------------------------------------------"
	echo "cp $TARFILE $ROOT/$TARFILE"
	cp $TARFILE $ROOT/$TARFILE
	echo "cp $DUMP $ROOT/$TARFILE"
	cp $DUMP $ROOT/$DUMP
	echo ">> Copie effectuée avec succès"
	echo ""

	cd $ROOT
	echo "Extraction des sources dans $ROOT" 
	echo "---------------------------------"
	echo "tar -xf $TARFILE"
	tar -xf $TARFILE
	echo ">> Extraction effectuée avec succès"
	echo ""

	echo "Restauration du dump de bdd dans la base $DBNAME"
	echo "------------------------------------------------"
	echo "mysql -u $DBUSER -p$DBPASS $DBNAME < $DUMP"
	mysql -h $DBSERV -u $DBUSER -p$DBPASS $DBNAME < $DUMP
	echo ""
	echo "Vidage des tables accesslog,search_dataset,search_index,search_total,sessions,watchdog"
	echo "--------------------------------------------------------------------------------------"
	mysql -h $DBSERV -u $DBUSER -D $DBNAME -p$DBPASS -e "TRUNCATE TABLE accesslog"
	mysql -h $DBSERV -u $DBUSER -D $DBNAME -p$DBPASS -e "TRUNCATE TABLE search_dataset"
	mysql -h $DBSERV -u $DBUSER -D $DBNAME -p$DBPASS -e "TRUNCATE TABLE search_index"
	mysql -h $DBSERV -u $DBUSER -D $DBNAME -p$DBPASS -e "TRUNCATE TABLE search_total"
	mysql -h $DBSERV -u $DBUSER -D $DBNAME -p$DBPASS -e "TRUNCATE TABLE sessions"
	mysql -h $DBSERV -u $DBUSER -D $DBNAME -p$DBPASS -e "TRUNCATE TABLE watchdog"
	echo ">> Restauration effectuée avec succès"
	echo ""
	echo "Suppression de l'archive tar et du dump"
	echo "-----------------------------------------------------"
	rm $TARFILE
	rm $DUMP
	echo ">> Suppression effectuée avec succès"
	echo ""
	echo "Attribution des droits apache (httpd) sur les sources"
	echo "-----------------------------------------------------"
	echo "chown –R $APUSER:$APGROUP $ROOT/*"
	chown $APUSER:$APGROUP -R $ROOT/*
	echo ">> Droits apache attribués avec succès"
	echo ""
        echo "Mise à jour du fichier de configuation de drupal"
        echo "-----------------------------------------------------"
        echo "sed -E \"... database => $DBNAME \" sites/default/settings.php"
        sed -e '' -E "s/^([[:space:]]+[\'\"]database[\'\"][[:space:]]+\=\>[[:space:]]+)([\'\"]).*[\'\"](.*)$/\1\2$DBNAME\2\3/" sites/default/settings.php
        echo "sed -E \"... username => $DBUSER \" sites/default/settings.php"
        sed -e '' -E "s/^([[:space:]]+[\'\"]username[\'\"][[:space:]]+\=\>[[:space:]]+)([\'\"]).*[\'\"](.*)$/\1\2$DBUSER\2\3/" sites/default/settings.php
        echo "sed -E \"... password => $DBPASS \" sites/default/settings.php"
        sed -e '' -E "s/^([[:space:]]+[\'\"]password[\'\"][[:space:]]+\=\>[[:space:]]+)([\'\"]).*[\'\"](.*)$/\1\2$DBPASS\2\3/" sites/default/settings.php
        echo "sed -E \"... host => $DBSERV \" sites/default/settings.php"
        sed -e '' -E "s/^([[:space:]]+[\'\"]host[\'\"][[:space:]]+\=\>[[:space:]]+)([\'\"]).*[\'\"](.*)$/\1\2$DBSERV\2\3/" sites/default/settings.php

	echo "Vidage des caches Drupal"
	echo "-----------------------------------------------------"
	export DRUSH_OPTIONS="-q"
	sudo -u $APUSER DRUSH_PHP="$PHP" /usr/local/bin/drush cc all
	set -e

	echo ""
	echo ""
	echo ">>>>>>>>>>>>>> INSTALLATION EFFECTUEE AVEC SUCCESS"
	echo ""
	echo ""
 fi
