import JSONAPISerializer from 'ember-data/serializers/json-api';

export default JSONAPISerializer.extend({

    normalizeResponse: function(store, primaryModelClass, payload, id) {
        var speakers = payload['resources'].find(resource => resource['id'] === 'speakers');
        var translationISO = false;

        var buildFragment = function(annotation) {
            var fragment = {
                'original': annotation['content']['data']['content']
            };
            if(annotation['content']['data']['transl']) {
                fragment['translation'] = annotation['content']['data']['transl']['@value'];
            }
            if(annotation['content']['data']['words']) {
                var words = [];
                annotation['content']['data']['words'].forEach(function(word) {
                    words.push({
                        'original': word['content'],
                        'translation': word['transl']['@value']
                    });
                });
                fragment['literal'] = words;
            }
            if(annotation['content']['data']['speaker']) {
                if(typeof annotation['content']['data']['speaker'] === 'object') {
                    var speaker = speakers['content']['data'].find(speaker => speaker['id'] === annotation['content']['data']['speaker']['id-ref']);
                    if(speaker) {
                        fragment['speaker'] = speaker['name'];
                    }
                } else {
                    fragment['speaker'] = annotation['content']['data']['speaker'];
                }
            }
            return fragment;
        };

        var annotations = [];
        payload['annotations'].forEach(function(annotation) {
            var previous = annotations[annotations.length - 1];
            if(previous && annotation['begin'] === previous.begin && annotation['end'] === previous.end) {
                previous.fragments.push(buildFragment(annotation));
            } else {
                var object = {
                    'fragments': [buildFragment(annotation)],
                    'begin': annotation['begin'],
                    'end': annotation['end'],
                };
                var information = payload['annotation-types'].find(function(t) { return t['corpus:begin'] === annotation['begin'] && t['corpus:end'] === annotation['end']; });
                if(information) {
                    object.title = information['dc:title'];
                }
                annotations.push(object);
            }
            if(!translationISO && annotation['content']['data']['transl']) {
                translationISO = annotation['content']['data']['transl']['@language'];    
            }
        });

        var response = {
            'data': {
                'id': id,
                'type': 'transcript',
                'attributes': {
                    'title': {},
                    'annotations': annotations
                }
            }
        };

        if(Array.isArray(payload['meta']['dc:title'])) {
            var original = payload['meta']['dc:title'].find(function(title) { return title['@language'] !== translationISO; });
            if(original) {
                response.data.attributes.title.original = original['@value'];
            }
            var translation = payload['meta']['dc:title'].find(function(title) { return title['@language'] === translationISO; });
            if(translation) {
                response.data.attributes.title.translation = translation['@value'];
            }            
        } else {
            response.data.attributes.title.original = payload['meta']['dc:title']['@value'];
        }


        return response;
    }

});
