import DS from 'ember-data';
import Ember from 'ember';
import _ from 'lodash/lodash';

export default DS.Model.extend({

    uri: DS.attr('string'),
    issued: DS.attr('date'),
    title: DS.attr('string'),
    language: DS.attr('string'),
    publisher: DS.attr('string'),
    transcript: DS.attr({ defaultValue: function() { return {}; } }),

    publishers: DS.attr({ defaultValue: function() { return []; } }),
    contributors: DS.attr({ defaultValue: function() { return []; } }),
    geoInfo: DS.attr({ defaultValue: function() { return {}; } }),
    mediaArray: DS.attr({ defaultValue: function() { return []; } }),

    duration_ms: DS.attr('number', {
        defaultValue: function() {
            var self = this;
            var duration = 0;
            Object.keys(this.get('mediaArray')).forEach(function(key) {
                if (!duration && self.get('mediaArray')[key].extent_ms) {
                    duration = self.get('mediaArray')[key].extent_ms;
                }
            });
            return duration;
        }
    }),

    media: Ember.computed('mediaArray', function() {
        var array = [];
        _.forEach(this.get('mediaArray'), function(media) {
            var index = array.findIndex(element => element.format === media.format);
            if(index > -1) {
                if (media.master) {
                    array.splice(index, 1, media);
                }
            } else {
                array.push(media);
            }
        });
        return array;
    }),

    video: Ember.computed('media', function() {
        return this.get('media').findIndex(element => element.format.match(new RegExp('^video/'))) > -1;
    }),

    duration: Ember.computed('duration_ms', function() {
        return this.get('duration_ms')/1000;
    }),

    publishers_disp: Ember.computed('publisher', 'publishers', function() {
        return this.get('publisher')?this.get('publisher'):this.get('publishers').join(', ');
    })

});
