<?php
namespace CorpusParole\Libraries;

class CocoonUtils {

    /**
     * Extract id form cocoon url.
     *
     * @return string
     */
    public static function getIdFromUri($uri) {
        return substr($uri, strlen(config('corpusparole.cocoon_doc_id_base_uri')));
    }

    /**
     * Extract id form corpus url.
     *
     * @return string
     */
    public static function getIdFromCorpusUri($uri) {
        return substr($uri, strlen(config('corpusparole.corpus_doc_id_base_uri')));
    }

    /**
     * Create a Corpus resource id (purl url)
     *
     * @return string
     */
    public static function getCorpusUriFromId($id) {
        return rtrim(config('corpusparole.corpus_doc_id_base_uri'),'/')."/$id";
    }

    public static function getCocoonPubUrl($id) {
        return rtrim(config('corpusparole.cocoon_doc_pub_base_uri'), '/')."/$id";
    }

}
