import Ember from 'ember';

export default Ember.Route.extend({

    page: 1,
    limit: 10,

    documents: [],
    model: Ember.observer('page', function() {
        var self = this;
        var promise = this.store.query('document', {
            page: this.get('page'),
            perpage: this.get('limit')
        });
        promise.then(function(value) {
            if(self.controller) {
                self.controller.set('page', self.get('page'));
                self.controller.set('documents', self.get('documents'));
            }
            self.set('documents', value);
        });
        return promise;
    }),

    serializeQueryParam: function(value, urlKey) {
        if (urlKey === 'date') {
            return value;
        }
        return '' + value;
    },

    setupController: function(controller) {
        this._super(...arguments);
        controller.set('page', this.get('page'));
        controller.set('limit', this.get('limit'));
        controller.set('documents', this.get('documents'));
    },

    deserializeQueryParam: function(value, urlKey) {
        if (urlKey === 'date') {
            var array = [];
            for (var i = 0; i < value.length; i++) {
                array.push(value[i]);
            }
            return array;
        }
        return value;
    },

    actions: {

        setPageQueryparams: function(type) {
            var page = this.get('page');
            if(type === 'previous') {
                page = page - 1;
            } else if(type === 'next') {
                page = page + 1;
            }
            this.propertyWillChange('page');
            this.set('page', page);
            this.propertyDidChange('page');
        },

        willTransition: function() {
            // Prevent navigation from removing query parameters
            var _this = this,
                queryParams = {};
            this.controller.get('queryParams').map(function(parameter){
                if(typeof parameter === 'object') {
                    Object.keys(parameter).forEach(function(value) {
                        queryParams[value] = _this.controller.get(value);
                    });
                } else {
                    queryParams[parameter] = _this.controller.get(parameter);
                }
            });
            this.transitionTo({ queryParams: queryParams });
        },

        didTransition: function() {
            // Append body classname depending on the route
            Ember.$('body').removeClass((this.controller.get('currentPath') || '').replace(/\//g, '-').dasherize());
            Ember.run.once(this, function() {
                Ember.$('body').addClass((this.controller.get('currentPath') ||'').replace(/\//g, '-').dasherize());
            });
        }

    }

});
