import Ember from 'ember';
import * as d3s from 'd3-scale';

const speakerClassScale = d3s.scaleQuantize()
  .domain([0, 1])
  .range(['fa-volume-down', 'fa-volume-up']);


export default Ember.Component.extend({
  classNames: ['player-sound-control'],

  popcorn: null,

  volume: Ember.computed('popcorn', {
    get: function() {
      let popcorn = this.get('popcorn');
      if(!popcorn) {
        return 0;
      }
      return popcorn.volume();
    },
    set: function(key, value) {
      let popcorn = this.get('popcorn');
      if(!popcorn) {
        return 0;
      }
      const newValue = Math.min(1.0, Math.max(0, value));
      popcorn.volume(newValue);
      return newValue;
    }
  }),

  muted: Ember.computed('popcorn', {
    get: function() {
      let popcorn = this.get('popcorn');
      if(!popcorn) {
        return false;
      }
      return popcorn.muted();
    },
    set: function(key, value) {
      let popcorn = this.get('popcorn');
      if(!popcorn) {
        return false;
      }
      if(value) {
        popcorn.mute();
      } else {
        popcorn.unmute();
      }
      return value;
    }

  }),

  mutedObserver: Ember.observer('muted', function() {
    const rangeslider = this.$("#sound-control-range-slider");
    if(!rangeslider) {
      return;
    }
    rangeslider.rangeslider('update', true);
  }),

  volumeObserver: Ember.observer('volume', function() {
    const rangeslider = this.$("#sound-control-range-slider");
    const volume = this.get('volume');
    if(!rangeslider) {
      return;
    }
    rangeslider.val(volume).change();
  }),

  popcornObserver: Ember.observer('popcorn', function() {
    let popcorn = this.get('popcorn');
    if(!popcorn) {
      return;
    }
    popcorn.on('volumechange', () => {  this.notifyPropertyChange('volume'); this.notifyPropertyChange('muted'); });

  }),

  speakerClass: Ember.computed('volume', 'muted', function() {
    const volume = this.get('volume');
    const muted = this.get('muted');
    if(muted || volume === 0 ) {
      return "fa-volume-off";
    } else {
      return speakerClassScale(volume);
    }
  }),

  mouseEnter: function() {
    let baseOffset = this.$("#sound-control-speaker").offset();
    if(this.get('muted')) {
      return;
    }
    this.$("#sound-control-scale").show(400);
    this.$("#sound-control-scale").offset({ top: baseOffset.top + 55, left: baseOffset.left});
  },
  mouseLeave: function() {
    this.$("#sound-control-scale").hide(400);
  },

  didInsertElement: function() {
    const volume = this.get('volume');
    let rangeslider = this.$('#sound-control-range-slider');
    rangeslider.rangeslider({
      polyfill: false,
      onSlide: (pos, value) => {
        this.set('volume', value);
      },
      onSlideEnd: (pos, value) => {
        this.set('volume', value);
      },
      onInit: function() {
        Ember.$(this).value = volume;
      }
    });
  },

  willDestroyElement: function() {
    this.$('#sound-control-range-slider').rangeslider('destroy');
  },

  actions: {
    muteToggle() {
      if(!this.get('volume')) {
        return;
      }
      this.set('muted', !this.get('muted'));
    },
    clickMinus() {
      if(this.get('muted')) {
        return;
      }
      let volume = this.get('volume');
      this.set('volume', volume - 0.1);
    },
    clickPlus() {
      if(this.get('muted')) {
        return;
      }
      let volume = this.get('volume');
      this.set('volume', volume + 0.1);
    }
  }

});
