/*jshint node:true*/
module.exports = function(app) {
  var express = require('express');
  var _ = require('lodash');

  var v1LexvoRouter = express.Router();

  var lexvoMappings = {
    "fra": "français",
    "gsw": "alémanique",
    "oci": "occitan"
  };

  v1LexvoRouter.get('/:id', function(req, res) {
    var idList = req.params.id.split(',');
    var resMap = _.reduce(idList, function(r, id) {
      r[id] = (id in lexvoMappings)?lexvoMappings[id]:null;
    }, {});
    res.send({
      'lexvoids': _.reduce(idList, function(r, id) {
        r[id] = (id in lexvoMappings)?lexvoMappings[id]:null;
        return r;
      }, {}),
    });
  });

  app.use('/api/v1/lexvo', v1LexvoRouter);
};
