require 'spec_helper'

describe 'concat' do
  it { is_expected.not_to eq(nil) }
  it { is_expected.to run.with_params().and_raise_error(Puppet::ParseError) }
  it { is_expected.to run.with_params([1]).and_raise_error(Puppet::ParseError) }
  it { is_expected.to run.with_params(1, [2]).and_raise_error(Puppet::ParseError) }
  it { is_expected.to run.with_params([1], [2], [3]).and_return([1, 2, 3]) }
  it { is_expected.to run.with_params(['1','2','3'],['4','5','6']).and_return(['1','2','3','4','5','6']) }
  it { is_expected.to run.with_params(['1','2','3'],'4').and_return(['1','2','3','4']) }
  it { is_expected.to run.with_params(['1','2','3'],[['4','5'],'6']).and_return(['1','2','3',['4','5'],'6']) }
  it { is_expected.to run.with_params(['1','2'],['3','4'],['5','6']).and_return(['1','2','3','4','5','6']) }
  it { is_expected.to run.with_params(['1','2'],'3','4',['5','6']).and_return(['1','2','3','4','5','6']) }

  it "should leave the original array intact" do
    argument1 = ['1','2','3']
    original1 = argument1.dup
    argument2 = ['4','5','6']
    original2 = argument2.dup
    result = subject.call([argument1,argument2])
    expect(argument1).to eq(original1)
    expect(argument2).to eq(original2)
  end
end
