import Ember from 'ember';

export default Ember.Controller.extend({
  queryParams: ['location', 'langue', 'discours', 'date', 'thematique'],
  location: null,
  langue: null,
  discours: null,
  date: [],
  thematique: null,
  isShowingModal: false,
  currentDetails: null,
  currentItem: {title: "example", master: 'http://www.noiseaddicts.com/samples_1w72b820/3921.mp3'},
  filteredSounds: Ember.computed('location', 'langue', 'discours', 'date', 'thematique', 'model', function() {
    var location = this.get('location');
    var langue = this.get('langue');
    var discours = this.get('discours');
    var date = this.get('date');
    var thematique = this.get('thematique');

    var sounds = this.get('model');

    if (location) {
      sounds = sounds.filterBy('spatial', location);
    }
    if (langue) {
      sounds = sounds.filterBy('language', langue);
    }
    if (discours) {
      sounds = sounds.filterBy('type', discours);
    }
    if (date.length > 0) {
      var temp = sounds;
      sounds.map(function(elt, index){
        if (date.indexOf(elt.get('created')) === -1){
          temp = temp.without(elt);
        }
      });
      sounds = temp;
    }
    if (thematique) {
      sounds = sounds.filterBy('thematique', thematique);
    }
    return sounds;
  }),
  actions: {
    deleteTag: function(query, item){
      var queryParams = {};
      if (query === 'date'){
        var array = this.get('date');
        if(array.indexOf(item) !== -1) {
        	array.splice(array.indexOf(item), 1);
        }
      }
      queryParams[query] = array || null;
      this.transitionToRoute({queryParams: queryParams});
    },
    play: function(item){
      this.set("currentItem", item);
      $("#audio-player").load();
      $(".result-item").toggleClass("playing", false);
      $("#"+item.id).toggleClass("playing", true);
    },
    details: function(item){
      if ($("#"+item.id).hasClass("details")){
          $("#"+item.id).toggleClass("details", false);
      } else{
        $(".result-item").toggleClass("details", false);
        $("#"+item.id).toggleClass("details", true);
      }
    },
    toggleModal: function(item){
      this.set("isShowingModal", !this.isShowingModal);
      this.set("currentDetails", item);
    }
  }
});
