import Ember from 'ember';

export default Ember.Route.extend({
  serializeQueryParam: function(value, urlKey, defaultValueType) {
    if (urlKey === 'date') {
      return value;
    }
    return '' + value;
  },
  deserializeQueryParam: function(value, urlKey, defaultValueType) {
    if (urlKey === 'date') {
      var arr = [];
      for (var i = 0; i < value.length; i++) {
        arr.push(parseInt(value[i]));
      }
      return arr;
    }

    return value;
  },
  model() {
    return this.store.findAll('sound');
  },
  actions: {
    willTransition: function(transition) {
      var _this = this;
      var queryParams = {};
      this.controller.get('queryParams').map(function(elt, index){
        queryParams[elt] = _this.controller.get(elt);
      });
      this.transitionTo({ queryParams: queryParams });
    }
  }
});
