class sysconfig::corpus (
    $vhost             = hiera('sysconfig::params::vhost',             $sysconfig::params::vhost),
    $corpus_app_key    = hiera('sysconfig::params::corpus_app_key',    $sysconfig::params::corpus_app_key),
    $db_name           = hiera('sysconfig::params::db_name',           $sysconfig::params::db_name),
    $db_drpl_name      = hiera('sysconfig::params::db_drpl_name',      $sysconfig::params::db_drpl_name),
    $db_user           = hiera('sysconfig::params::db_user',           $sysconfig::params::db_user),
    $db_pw             = hiera('sysconfig::params::db_pw',             $sysconfig::params::db_pw),
    $db_host           = hiera('sysconfig::params::db_host',           $sysconfig::params::db_host),
    $db_port           = hiera('sysconfig::params::db_port',           $sysconfig::params::db_port),
    $es_host           = hiera('sysconfig::params::es_host',           $sysconfig::params::es_host),
    $es_port           = hiera('sysconfig::params::es_port',           $sysconfig::params::es_port),
    $es_instance       = hiera('sysconfig::params::es_instance',       $sysconfig::params::es_instance),
    $hdl_host          = hiera('sysconfig::params::hdl_host',          $sysconfig::params::hdl_host),
    $hdl_web_port      = hiera('sysconfig::params::hdl_web_port',      $sysconfig::params::hdl_web_port),
    $hdl_key_pswd      = hiera('sysconfig::params::hdl_key_pswd',      $sysconfig::params::hdl_key_pswd),
    $hdl_prefix        = hiera('sysconfig::params::hdl_prefix',        $sysconfig::params::hdl_prefix),
    $hdl_test_prefix   = hiera('sysconfig::params::hdl_test_prefix',   $sysconfig::params::hdl_test_prefix),
    $hdl_prefix_admin  = hiera('sysconfig::params::hdl_prefix_admin',  $sysconfig::params::hdl_prefix_admin),
    $geonames_username = hiera('sysconfig::params::geonames_username', $sysconfig::params::geonames_username)
) inherits sysconfig::params {

    file { "/etc/www/corpus_env.conf":
        ensure => file,
        content => template("sysconfig/corpus/corpus_env.conf.erb"),
        require => [Package['httpd'], File['/etc/www']],
        notify => Service['httpd']
    }

    file { "/var/www/corpusdelaparole/corpus-back/.env":
        ensure => file,
        owner => 'apache',
        group => 'apache',
        content => template("sysconfig/corpus/local.env.erb"),
        require=>File["/var/www/corpusdelaparole/corpus-back"]
    }

}
