<?php
namespace CorpusParole\Repositories;

use CorpusParole\Models\Document;

interface DocumentRepository {

    public function all();

    public function get($id);

    public function save(Document $doc);

    /**
     * Paginate all document as a paginator.
     *
     * @param  int  $perPage
     * @param  string  $pageName
     * @return \Illuminate\Contracts\Pagination\LengthAwarePaginator
     */
    public function paginateAll($perPage = 15, $pageName = 'page', $page = null);

    /**
     * Resolve lexvo id for all documents in the list
     * this allow to optimise the call of lexvo repository
     */
    public function resolveLexvo(Array $docList);

    public function getCount();
}
