#!/usr/bin/env sh
PATH=/opt/remi/php56/root/usr/bin/:$PATH

if [ -x /usr/local/bin/drush ] && [ -f /var/www/corpusdelaparole/drupal/sites/default/settings.php ]; then
    echo "Reactivate corpus module"
    /usr/local/bin/drush -r /var/www/corpusdelaparole/drupal pm-enable -y corpus
    echo "Clear drupal cache"
    /usr/local/bin/drush -r /var/www/corpusdelaparole/drupal cc all
fi


if [ -d /var/www/corpusdelaparole/corpus-back/ ]; then
    pushd /var/www/corpusdelaparole/corpus-back/  > /dev/null

    echo "Correcting file permissions for back office"
    chgrp -R apache storage bootstrap/cache
    chmod -R ug+rwx storage bootstrap/cache

    echo "Migrating back office database"
    php artisan migrate -n --force

    echo "Optimizing framework"
    php artisan optimize
    php artisan config:cache
    php artisan route:cache

    echo "Correcting file permissions for back office"
    chgrp -R apache storage bootstrap/cache
    chmod -R ug+rwx storage bootstrap/cache

    echo "Put back application in production"
    php artisan up

    popd  > /dev/null
fi


echo "Restart httpd"
/usr/bin/systemctl restart httpd
