import Ember from 'ember';

export default Ember.Component.extend({
    tagName: "span",

    lexvoResolver: Ember.inject.service(),

    _resolveLexvoIds: Ember.on('init', Ember.observer('language', function() {
      this.get('lexvoResolver').getName(this.get('language')).then(function(str) {
          this.set('resolvedName', str);
      }.bind(this));
    })),

    code: Ember.computed('language', function() {
      var rawLanguage = this.get('language');
      if(rawLanguage && rawLanguage.startsWith(this.get('constants').LEXVO_BASE_URL) ) {
        return rawLanguage.substr(this.get('constants').LEXVO_BASE_URL.length);
      }
      return rawLanguage;
    }),
    isLanguageLink: Ember.computed.match('language', /^http\:\/\//)

});
