<?php

namespace CorpusParole\Http\Controllers\Api;

use Illuminate\Http\Request;
//use Illuminate\Http\Response;

use CorpusParole\Http\Requests;
use CorpusParole\Http\Controllers\Controller;
use CorpusParole\Repositories\DocumentRepository;

class DocumentController extends Controller
{
    /**
     * Create a new controller instance.
     */
    public function __construct(DocumentRepository $documentRepo) {
        $this->documentRepository = $documentRepo;
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        $paginator = $this->documentRepository->paginateAll();
        $res = $paginator->toArray();
        if(array_key_exists('data', $res)) {
            $documents = $res['data'];
            unset($res['data']);
            $res['documents'] = $this->documentRepository->resolveLexvo($documents);
        }
        return response()->json($res);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  Request  $request
     * @return Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function show($id)
    {
        $doc = $this->documentRepository->get($id);
        $this->documentRepository->resolveLexvo([$doc,]);
        if(is_null($doc)) {
            abort(404);
        }
        return response()->json(["document" => $doc]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified document in storage.
     *
     * @param  Request  $request
     * @param  int  $id
     * @return Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->json();
        $document = $data->get('document');
        $doc = $this->documentRepository->get($id);
        if(is_null($doc)) {
            abort(404);
        }

        //for now, update contributors only
        $doc->setContributors($document['contributors']);

        $this->documentRepository->save($doc);

        return response('', 204);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id)
    {
        //
    }
}
