import Ember from 'ember';

export default Ember.Component.extend({

    classNames: ['playlist-component'],

    filter: Ember.inject.service(),
    player: Ember.inject.service(),

    documents: Ember.computed('model', 'filter.location', 'filter.language', 'filter.discourse', 'filter.date', 'filter.theme', function() {
        var self = this;
        var documents = this.get('model');
        if (this.get('filter').get('date').length > 0) {
            var copy = documents;
            documents.map(function(document) {
                if (self.get('filter').get('date').indexOf(document.get('created')) === -1){
                    copy = copy.without(document);
                }
            });
            documents = copy;
        }
        if (this.get('filter').get('discourse')) {
            documents = documents.filterBy('type', this.get('filter').get('discourse'));
        }
        if (this.get('filter').get('language')) {
            documents = documents.filterBy('language', this.get('filter').get('language'));
        }
        if (this.get('filter').get('location')) {
            documents = documents.filterBy('spatial', this.get('filter').get('location'));
        }
        if (this.get('filter').get('theme')) {
            documents = documents.filterBy('thematique', this.get('filter').get('theme'));
        }
        return documents;
    }),

    documentsLoaded: Ember.observer('documents', function() {
        this.get('player').set('items', this.get('documents').map(function(document) {
            return document.get('id');
        }));
        if(this.get('player').get('items').length && this.get('player').get('playing') === false) {
            this.get('player').set('item', this.get('player').get('items')[0]);    
        }
    }).on('init'),

    init: function() {
        this._super(...arguments);
    },

    didRender: function() {
        this._super(...arguments);
        this.$().find('ul').height(Ember.$('.corpus-app-wrapper').outerHeight() - (Ember.$('.filter-component').outerHeight() + this.$().find('h2').outerHeight()));
    },

    actions: {

        play: function(id) {
            this.get('player').play(id);
        },

        pause: function(id) {
            this.get('player').pause();
        },

        displayNotice: function(id) {
            if(this.get('player').get('item') === id) {
                if(this.get('player').get('window') !== 'notice') {
                    this.get('player').set('window', 'notice');
                } else {
                    this.get('player').set('window', '');
                }
            } else {
                if(this.get('notice') !== id) {
                    this.set('notice', id);
                } else {
                    this.set('notice', null);
                }
            }

        }

    }

});
