import * as constants from 'corpus-common-addon/utils/constants';

import ResolverService from 'corpus-common-addon/services/resolver-service';

export default ResolverService.extend({

    storeKeyBase: 'bnf',
    apiPath:  '/api/v1/resolvers/bnf/',
    resDocRoot: 'bnfids',

    init() {
        this._super(...arguments);
        console.log("BNF", this);
    },

    processId: function(id) {
        var bnfId = id;
        if(id.startsWith(constants.BNF_BASE_URL + constants.BNF_ARK_BASE_ID)) {
            bnfId = id.slice((constants.BNF_BASE_URL + constants.BNF_ARK_BASE_ID).length);
        }
        else if (id.startsWith(constants.BNF_ARK_BASE_URL + constants.BNF_ARK_BASE_ID)) {
            bnfId = id.slice((constants.BNF_ARK_BASE_URL + constants.BNF_ARK_BASE_ID).length);
        }
        else if (id.startsWith(constants.BNF_ARK_BASE_ID)) {
            bnfId = id.slice(constants.BNF_ARK_BASE_ID.length);
        }
        return bnfId;
    },

    getReturnDictKey: function(id) { return constants.BNF_ARK_BASE_ID+id; },

    getLabel: function(id) { return this.getName(id); }

});
