import * as constants from 'corpus-common-addon/utils/constants';
import _ from 'lodash/lodash';

export function isLexvoLink(s) {
  return s && typeof s === 'string' && s.startsWith(constants.LEXVO_BASE_URL);
};

export function isBnfLink(s) {
  return s && typeof s === 'string' && (s.startsWith(constants.BNF_BASE_URL) || s.startsWith(constants.BNF_ARK_BASE_URL) || s.startsWith(constants.BNF_ARK_BASE_ID));
};

export function isArkBnfLink(s) {
  return s && typeof s === 'string' && (s.startsWith(constants.BNF_BASE_URL + constants.BNF_ARK_BASE_ID) || s.startsWith(constants.BNF_ARK_BASE_URL + constants.BNF_ARK_BASE_ID));
};

export function isGeonamesLink(s) {
  return (typeof s === 'string') && (s.match(constants.GEONAMES_BASE_URLS) !== null);
}

export function switchArkBnfLink(s) {
  if (!s) {
    return s;
  }
  if (typeof s === 'string' && s.startsWith(constants.BNF_BASE_URL + constants.BNF_ARK_BASE_ID)) {
    return constants.BNF_ARK_BASE_URL + s.slice(constants.BNF_BASE_URL.length);
  } else if (typeof s === 'string' && s.startsWith(constants.BNF_ARK_BASE_URL + constants.BNF_ARK_BASE_ID)) {
    return constants.BNF_BASE_URL + s.slice(constants.BNF_ARK_BASE_URL.length);
  } else {
    return s;
  }
};

export function calculateBnfArkControlChar(id) {
  if (!id) {
    return null;
  }
  var sum = _.reduce(id, function(s, c, i) {
    return s + (i + 1) * (c in constants.NOID_CHARS_POS ? constants.NOID_CHARS_POS[c] : 0);
  }, 0);
  return constants.NOID_CHARS[sum % constants.NOID_CHARS.length];
};
