import Ember from 'ember';

export default Ember.Route.extend({

    modelQueryParam: 'world',

    model: function() {
        return this.store.query('geostat', {
            'area': this.get('modelQueryParam'),
            'details': 1
        });
    },

    deactivate: function () {
        this.set('modelQueryParam', 'world');
    },

    setupController: function(controller) {
        this._super(...arguments);
        controller.set('modelQueryParam', this.get('modelQueryParam'));
    },

    actions: {
        setModelQueryParam: function(id) {
            this.set('modelQueryParam', id);
            this.refresh();
        }
    }

});
