import Ember from 'ember';
import Popcorn from 'popcorn';

export default Ember.Component.extend({
    classNames: ['player-component'],
    classNameBindings: ['video:video'],
    video: Ember.computed.alias('player.model.video'),

    player: Ember.inject.service(),
    popcorn: null,

    head: 0,
    remaining: 0,

    isFirst: false,
    isLast: false,

    item: Ember.computed('player.model', function() {
        return this.get('player').get('model');
    }),

    modelLoaded: Ember.observer('player.model', function() {
        var items = this.get('player').get('items');
        var index = items.indexOf(this.get('player').get('item'));
        this.set('isFirst', index === 0);
        this.set('isLast', index === items.length - 1);
        if(this.get('player').get('playing')) {
            this.play();
        }
    }),

    itemLoaded: Ember.observer('player.model.media', function() {
        this.get('popcorn').load();
    }),

    playingObserver: Ember.observer('player.playing', function() {
        if(this.get('player').get('playing')) {
            this.play();
        } else {
            this.pause();
        }
    }),

    init: function() {
        var self = this;
        this.get('player').on('progressupdate', function(progress) {
            self.get('popcorn').currentTime(progress / 1000);
        });

        this._super(...arguments);
    },

    didInsertElement: function() {
        this.set('popcorn', new Popcorn('#popcorn-audio'));
        this.get('popcorn').on('loadeddata', Ember.run.bind(this, this.get('onUpdate')));
        this.get('popcorn').on('timeupdate', Ember.run.bind(this, this.get('onUpdate')));

        this.get('player').on('reset', Ember.run.bind(this, function(id) {
            if(this.get('player').get('item') !== id) {
                this.get('popcorn').on('loadeddata', Ember.run.bind(this, this.get('play')));
            } else {
                this.send('toggle');
            }
        }));
    },

    onUpdate: function() {
        var progress = this.get('popcorn').currentTime();
        var duration = this.get('popcorn').duration();
        this.$('.bar .value').width(progress * 100 / duration + '%');
        this.get('player').setProgress(progress * 1000);
        this.set('head', progress);
        this.set('remaining', duration - progress);
    },

    play: function() {
        this.get('popcorn').play();
        Ember.$(document).attr('title', this.get('player').get('model').get('title') + ' - ' + Ember.$(document).attr('title'));
    },

    pause: function() {
        this.get('popcorn').pause();
        Ember.$(document).attr('title', Ember.$(document).attr('title').split(' - ').pop());
    },

    actions: {

        toggle: function() {
            this.get('player').set('playing', !this.get('player').get('playing'));
        },

        backward: function() {
            var index = this.get('player').get('items').indexOf(this.get('player').get('item'));
            var item = this.get('player').get('items')[index - 1];
            this.get('player').set('item', item);
        },

        forward: function() {
            var index = this.get('player').get('items').indexOf(this.get('player').get('item'));
            var item = this.get('player').get('items')[index + 1];
            this.get('player').set('item', item);
        },

        setTime: function(event) {
            this.get('popcorn').currentTime(event.layerX * this.get('popcorn').duration() / Ember.$(event.target).width());
        },

        display: function(el) {
            this.get('player').displayAdditionalInformation(el);
        }

    }
});
