<?php
/**
 * @file
 * Provide views data and handlers.
 */

/**
 * Implements hook_views_plugins().
 */
function views_bootstrap_views_plugins() {
  $module_path = drupal_get_path('module', 'views_bootstrap');

  return array(
    'style' => array(
      'views_bootstrap_carousel_plugin_style' => array(
        'title' => t('Bootstrap Carousel'),
        'help' => t('Bootstrap Carousel Style'),
        'path' => $module_path . '/plugins/carousel',
        'handler' => 'ViewsBootstrapCarouselPluginStyle',
        'parent' => 'default',
        'theme' => 'views_bootstrap_carousel_plugin_style',
        'theme path' => $module_path . '/templates/carousel',
        'theme file' => 'theme.inc',
        'uses row plugin' => TRUE,
        'uses grouping' => TRUE,
        'uses options' => TRUE,
        'type' => 'normal',
        //@TODO:  'uses row plugin' => FALSE, 'uses fields' => TRUE,
      ),
      'views_bootstrap_thumbnail_plugin_style' => array(
        'title' => t('Bootstrap Thumbnails'),
        'help' => t('Bootstrap Thumbnails Style'),
        'path' => $module_path . '/plugins/thumbnail',
        'handler' => 'ViewsBootstrapThumbnailPluginStyle',
        'parent' => 'default',
        'theme' => 'views_bootstrap_thumbnail_plugin_style',
        'theme path' => $module_path . '/templates/thumbnail',
        'theme file' => 'theme.inc',
        'uses row plugin' => TRUE,
        'uses grouping' => TRUE,
        'uses options' => TRUE,
        'type' => 'normal',
      ),
      'views_bootstrap_grid_plugin_style' => array(
        'title' => t('Bootstrap Grid'),
        'help' => t('Bootstrap Grid Style'),
        'path' => $module_path . '/plugins/grid',
        'handler' => 'ViewsBootstrapGridPluginStyle',
        'parent' => 'default',
        'theme' => 'views_bootstrap_grid_plugin_style',
        'theme path' => $module_path . '/templates/grid',
        'theme file' => 'theme.inc',
        'uses row plugin' => TRUE,
        'uses grouping' => TRUE,
        'uses options' => TRUE,
        'type' => 'normal',
      ),
      'views_bootstrap_accordion_plugin_style' => array(
        'title' => t('Bootstrap Accordion'),
        'help' => t('Bootstrap Accordion Style'),
        'path' => $module_path . '/plugins/accordion',
        'handler' => 'ViewsBootstrapAccordionPluginStyle',
        'parent' => 'default',
        'theme' => 'views_bootstrap_accordion_plugin_style',
        'theme path' => $module_path . '/templates/accordion',
        'theme file' => 'theme.inc',
        'uses row plugin' => TRUE,
        'uses grouping' => TRUE,
        'uses options' => TRUE,
        'type' => 'normal',
        //@TODO:  'uses row plugin' => FALSE, 'uses fields' => TRUE,
      ),
      'views_bootstrap_tab_plugin_style' => array(
        'title' => t('Bootstrap Tab'),
        'help' => t('Bootstrap Tab Style'),
        'path' => $module_path . '/plugins/tab',
        'handler' => 'ViewsBootstrapTabPluginStyle',
        'parent' => 'default',
        'theme' => 'views_bootstrap_tab_plugin_style',
        'theme path' => $module_path . '/templates/tab',
        'theme file' => 'theme.inc',
        'uses row plugin' => TRUE,
        'uses grouping' => TRUE,
        'uses options' => TRUE,
        'type' => 'normal',
        //@TODO:  'uses row plugin' => FALSE, 'uses fields' => TRUE,
      ),
      'views_bootstrap_media_plugin_style' => array(
        'title' => t('Bootstrap Media Object'),
        'help' => t('Bootstrap Media Object Style'),
        'path' => $module_path . '/plugins/media',
        'handler' => 'ViewsBootstrapMediaPluginStyle',
        'parent' => 'default',
        'theme' => 'views_bootstrap_media_plugin_style',
        'theme path' => $module_path . '/templates/media',
        'theme file' => 'theme.inc',
        'uses row plugin' => TRUE,
        'uses grouping' => TRUE,
        'uses options' => TRUE,
        'type' => 'normal',
      ),
      'views_bootstrap_table_plugin_style' => array(
        'title' => t('Bootstrap Table'),
        'help' => t('Displays rows in Bootstrap Table Style'),
        'path' => $module_path . '/plugins/table',
        'handler' => 'ViewsBootstrapTablePluginStyle',
        'parent' => 'table',
        'theme' => 'views_bootstrap_table_plugin_style',
        'theme path' => $module_path . '/templates/table',
        'theme file' => 'theme.inc',
        'uses row plugin' => FALSE,
        'uses row class' => TRUE,
        'uses fields' => TRUE,
        'uses options' => TRUE,
        'type' => 'normal',
      ),
      'views_bootstrap_list_group_plugin_style' => array(
        'title' => t('Bootstrap List Group'),
        'help' => t('Bootstrap List Group Style'),
        'path' => $module_path . '/plugins/list_group',
        'handler' => 'ViewsBootstrapListGroupPluginStyle',
        'parent' => 'default',
        'theme' => 'views_bootstrap_list_group_plugin_style',
        'theme path' => $module_path . '/templates/list_group',
        'theme file' => 'theme.inc',
        'uses row plugin' => TRUE,
        'uses grouping' => TRUE,
        'uses options' => TRUE,
        'type' => 'normal',
        //@TODO:  'uses row plugin' => FALSE, 'uses fields' => TRUE,
      ),
    ),
    'row' => array(
      'views_bootstrap_carousel_plugin_rows' => array(
        'title' => t('Bootstrap Carousel'),
        'help' => t('Choose the fields to display in Bootstrap Carousel Style.'),
        'path' => $module_path . '/plugins/carousel',
        'handler' => 'ViewsBootstrapCarouselPluginRows',
        'theme' => 'views_bootstrap_carousel_plugin_rows',
        'theme path' => $module_path . '/templates/carousel',
        'theme file' => 'theme.inc',
        'uses fields' => TRUE,
        'uses options' => TRUE,
        'type' => 'normal',
      ),
      'views_bootstrap_thumbnail_plugin_rows' => array(
        'title' => t('Bootstrap Thumbnail'),
        'help' => t('Choose the fields to display in Bootstrap Thumbnail Style.'),
        'path' => $module_path . '/plugins/thumbnail',
        'handler' => 'ViewsBootstrapThumbnailPluginRows',
        'theme' => 'views_bootstrap_thumbnail_plugin_rows',
        'theme path' => $module_path . '/templates/thumbnail',
        'theme file' => 'theme.inc',
        'uses fields' => TRUE,
        'uses options' => TRUE,
        'type' => 'normal',
      ),
    ),
  );
}
