/**
 * Backbone 1.x depends on jQuery >=1.7 (it uses jQuery.fn.on & jQuery.fn.off).
 * We re-implement these in terms of jQuery.fn.bind, jQuery.fn.delegate,
 * jQuery.fn.unbind, and jQuery.fn.undelegate.
 * This allows us to use Backbone 1.x with Drupal 7's jQuery 1.4.
 */
if (!jQuery.fn.on && !jQuery.fn.off) {
  jQuery.fn.on = function (types, selector, data, fn) {
    if (typeof selector !== "string") {
      return this.bind(types, selector, data);
    }
    else {
      return this.delegate(selector, types, data, fn);
    }
  };
  jQuery.fn.off = function (types, selector, fn) {
    if (typeof selector !== "string") {
      return this.unbind(types, selector, fn);
    }
    else {
      return this.undelegate(selector, types, fn);
    }
  };
}
