import Ember from 'ember';
import * as commonUtils from 'corpus-common-addon/utils/utils';
import * as commonConstants from 'corpus-common-addon/utils/constants';

export default Ember.Component.extend({
  classNames: ['notice-location-component'],
  filter: Ember.inject.service(),

  zoom: 6,
  tilesUrl: "https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png",

  location: Ember.computed('geoInfo', function() {
    return [this.get('geoInfo.latitude'), this.get('geoInfo.longitude')];
  }),

  hasCoordinates: Ember.computed('geoInfo', function() {
    return Boolean(this.get('geoInfo.longitude')) && Boolean(this.get('geoInfo.latitude'));
  }),

  geonamesLink: Ember.computed('geoInfo.ref-locs', function() {
    let link = null;
    this.get('geoInfo.ref-locs').forEach(l => {
      if(commonUtils.isGeonamesLink(l)) {
        return link=l;
      }
    });
    return link;
  }),

  otherRefLinks: Ember.computed.filter('geoInfo.ref-locs', l => { return !commonUtils.isGeonamesLink(l); }),

  actions: {
    addLocationFilter: function(id) {
      this.get('filter').setFilter('location', commonConstants.GEONAMES_BASE_URL + id);
    }
  }

});
