<?php

namespace CorpusParole\Providers;

use Config;
use CorpusParole\Libraries\Sparql\GuzzleSparqlClient;
use CorpusParole\Services\BnfResolver;

use Illuminate\Support\ServiceProvider;

class BnfServiceProvider extends ServiceProvider
{
    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->bind('CorpusParole\Services\BnfResolverInterface', function($app) {
            $sparqlClient = new GuzzleSparqlClient($app['Guzzle'], config('corpusparole.bnf_query_url'), null);
            return new BnfResolver($sparqlClient);
        });
    }
}
