<?php

namespace CorpusParole\Providers;

use Config;
use CorpusParole\Libraries\Sparql\GuzzleSparqlClient;
use CorpusParole\Services\LexvoResolver;

use Illuminate\Support\ServiceProvider;

class LexvoServiceProvider extends ServiceProvider
{
    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->bind('CorpusParole\Services\LexvoResolverInterface', function($app) {
            $sparqlClient = new GuzzleSparqlClient($app['Guzzle'], config('corpusparole.lexvo_rdf4j_query_url'), null);
            return new LexvoResolver($sparqlClient);
        });
    }
}
