<?php

namespace CorpusParole\Providers;

use Illuminate\Support\ServiceProvider;
use GuzzleHttp\Client;

/**
 * guzzle Service Provider, inspired by https://github.com/urakozz/laravel-guzzle
 */
class GuzzleServiceProvider extends ServiceProvider
{

    private function bindToKey($key) {
        $this->app->bind($key, function() {
            $config = isset($this->app['config']['guzzle']) ? $this->app['config']['guzzle'] : [];
            return new Client($config);
        });
    }
    /**
     * Register the Guzzle provider
     *
     * @return GuzzleClient
     */
    public function register()
    {
        $this->bindToKey('Guzzle');
        $this->bindToKey('GuzzleHttp\Client');
    }
}
