import Ember from 'ember';

export default Ember.Component.extend({

  tagName: "td",
  classNames: ['bo-doc-contributor-nameurl-cell'],
  _colspan: 2,
  attributeBindings: [ '_colspan:colspan'],
  viafId: null,
  isEditing: false,
  valueChanged: Ember.K,

  urlPresent: Ember.computed.bool('url'),

  initialViafId: Ember.computed('url', 'name', function() {
    let name = this.get('name');
    let url = this.get('url');
    return {
      label: name,
      value: name,
      id: "",
      url: url,
      nametype: ""
    };
  }),

  _nameurlChanged: Ember.observer('name', 'url', function() {
    this.get('valueChanged')();
  }),

  _autocompleteComponentChanged: Ember.observer('autocompleteComponent', function() {
    if(this.get('isEditing') && this.get('autocompleteComponent')) {
      this.get('autocompleteComponent').$('input').focus();
    }
  }),

  _viafIdChanged: Ember.observer('viafId', function() {
    let viafId = this.get('viafId');
    if(viafId) {
      this.set('url', viafId.url);
      this.set('name', viafId.value);
    }
  }),

});
