import DS from 'ember-data';
import Ember from 'ember';
import _ from 'lodash/lodash';
import * as utils from 'corpus-common-addon/utils/utils';

export default DS.Model.extend({
  // id: attr('string'),
  uri: DS.attr('string'),

  title: DS.attr('string'),

  languages: DS.attr({ defaultValue: function() { return []; } }),

  publishers: DS.attr({ defaultValue: function() { return []; } }),

  contributors: DS.attr({ defaultValue: function() { return []; } }),

  subjects: DS.attr({ defaultValue: function() { return []; } }),

  geoInfo: DS.attr({ defaultValue: function() { return []; } }),

  mediaArray: DS.attr({ defaultValue: function() { return []; } }),

  encodedId: Ember.computed('id', function() {
    return encodeURIComponent(this.get('id'));
  }),

  mediaList: Ember.computed('mediaArray', function() {
    const res = [];
    let mp3 = null;

    _.forEach(this.get('mediaArray'), function(m) {
      if (m.format === 'audio/mpeg') {
        mp3 = m;
      } else if (m.format.startsWith('audio/')) {
        res.push(m);
      }
    });
    if (mp3) {
      res.unshift(mp3);
    }

    return res;
  }),

  reflocs: Ember.computed('geoInfo', function() {
    return this.get('geoInfo')['ref-locs'];
  }),

  addContributor: function(contribDef) {
    const contributors = this.get('contributors');

    if (_.findIndex(contributors, function(c) { return _.isEqual(c, contribDef); }) < 0) {
      contributors.pushObject(contribDef);

    }

    // must set dirty
    this.set('contributors', _.clone(this.get('contributors')));
  },
  removeContributor: function(contribDef) {
    const contributors = this.get('contributors');
    const index = _.findIndex(contributors, function(c) { return _.isEqual(c, contribDef); });

    if (index >= 0) {

      contributors.removeAt(index);
    }
    // must set dirty
    this.set('contributors', _.clone(this.get('contributors')));
  },
  saveContributor: function(contribDef, index) {
    const contributors = this.get('contributors');

    if (index < 0 || index >= contributors.length) {
      return;
    }

    const contribDefMap = { name: contribDef.name || '', url: contribDef.url || '', role: contribDef.role || '' };
    const existingContribs = _.filter(contributors, function(c, i) {

      return (i !== index && _.isEqual({ name: c.name || '', url: c.url || '', role: c.role || '' }, contribDefMap));
    });

    if (existingContribs.length > 0) {
      // contributor exists, remove contributor @ index
      contributors.removeAt(index);
    } else {
      contributors[index] = contribDef;
    }

    // must set dirty only if needed
    this.set('contributors', _.clone(this.get('contributors')));
  },
  removeSubject: function(subjectDef) {
    const subjects = this.get('subjects');
    const index = _.findIndex(subjects, function(s) { return _.isEqual(s, subjectDef); });

    if (index >= 0) {
      subjects.removeAt(index);
    }
    // must set dirty
    this.set('subjects', _.clone(subjects));
  },
  addSubject: function(subjectDef) {
    const subjects = this.get('subjects');

    if (_.findIndex(subjects, function(s) { return _.isEqual(s, subjectDef) || _.isEqual(s, utils.switchArkBnfLink(subjectDef)); }) < 0) {
      subjects.pushObject(subjectDef);
    }
    // must set dirty
    this.set('subjects', _.clone(subjects));
  }

});
