# Projet Corpus de la parole

## Prérequis
La plateforme de dévelopement visée est MacOS et Linux.
Les éléments suivant sont des prérequis:
  - php >= 5.6
  - Vagrant
  - Ansible.
  - node

### php

### node

### Vagrant
Vagrant est utilisé pour le développement du back-office et la contruction des pacquets RPM.

### Ansible
Ansible n'est nécessaire que pour lancer l'environement de contruction des RPM.
Ansible sera soit installé globalement, soit installé dans un environement virtuel. dans ce cas, `virtualenv-wrapper` doit être installé et l'environement virtuel doit avoir le nom `ansible`.

## Lancement VM dev
- `cd /dev`
- `cp provisioning/custom.yaml.tmpl provisioning/custom.yaml`
- édition de `provisioning/custom.yaml`
- `vagrant up` (nécessite une connexion internet)
- url : http://vhost/corpus
- accès sesame workbench : http://vhost:8080/openrdf-workbench
- chargement des données dans `corpus` et `corpus_raw`

## Lancement VM de build
- Activation Ansible
- `cd /build`
- `vagrant up`

## Initialisation env de dev
- `cd /server/bo_client`
- `npm install`
- `./node_modules/.bin/bower install`
- `cd /server/src`
- télécharger composer.phar (https://getcomposer.org/) et le mettre dans le répertoire server/src
- `php composer.phar install`
- `npm install`
- `./node_modules/.bin/bowerbower install`

## Commandes bo_client
- `ember serve`
- `ember build` -> résultat dans `server/bo_client/dist`


## Commandes serveur php
- Compilation css/js : `gulp` -> cette commande lance `ember build` de `/server/bo_client`
- `php artisan serve`

## Creation de version
- mettre à jour le numéro de version. Pour cela lancer le script `build/set-version.sh "x.y.z"`, avec "x.y.z" le numéro de version
- Dans le répertoire `build`, lancer la commande `./build.sh -p && ./build_puppet.sh`


### Création du RPM contenant les fichiers `puppet`
- lancer le script `build/build_puppet.sh`.
- le fichier rpm se trouvera dans `/build/dist` sous le nom `puppet-corpusdelaparole-<version>-<iteration>.rpm`

### Création du RPM de l'application
- lancer le script `build/build.sh`. options:
    - `-d`: build debug
    - `-p`: build de production
- le fichier rpm se trouvera dans `/build/dist` sous le nom `corpusdelaparole-<version>-<iteration>.rpm`

### Étapes du processus de build
- mettre à jour le fichier version `server/src/config/version.php`
- mettre à jour le fichier version `cms/app-client/package.json`
- `cd /server/src`
- s'assurer que les sources sont à jour: `php composer.phar install` + `npm install` + `bower install`
- `gulp copy-build`
- `cd /cms/app-client`
- `npm install`
- `bower install`
- `ember build --prod` ou `ember build`
- `cd /cms`
- `npm install` pour installer gulp + dépendances
- `gulp copy-build`
- `cd /build`
- `vagrant ssh -c "/vagrant/build_rpm.sh"`
- le fichier rpm se trouvera dans `/build/dist`


## installation rpm sur serveur
- 1ère installation: `rpm -i /path/to/corpusdelaparole-<version>-<iteration>.rpm`
- Mise à jour: `rpm -U /path/to/corpusdelaparole-<version>-<iteration>.rpm`
- ensuite : création du fichier `/etc/www/corpus_env.conf`
- après un update : drush cc all
