<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
|
*/
Route::group(['prefix' => 'v1'] , function() {

    Route::pattern('id', ".*");
    Route::get('documents/{id}/transcript', 'Api\DocumentController@transcript');
    Route::resource('documents', 'Api\DocumentController', [
            'only' => ['index', 'show']
    ]);


    Route::group(['prefix' => 'resolvers'], function() {
        Route::get('viaf/{id}', 'Api\ViafController@show');
        Route::get('lexvo/{id}', 'Api\LexvoController@show');
        Route::get('bnf/{id}', 'Api\BnfController@show');
        Route::get('geonames/{id}', 'Api\GeonamesController@show');
    });


    Route::group(['prefix' => 'stats'], function() {
        Route::get('languages', 'Api\LanguageController@index');
        Route::get('themes', 'Api\ThemeController@index');
        Route::get('discourses', 'Api\DiscourseController@index');
        Route::get('datestats', 'Api\DateStatsController@index');
        Route::get('dateminmax', 'Api\DateStatsController@minmax');
        Route::get('geostats', 'Api\GeoStatsController@index');
    });
});
