import Ember from 'ember';
import _ from 'lodash';

export default Ember.Route.extend({

    constants: Ember.inject.service(),
    player: Ember.inject.service(),
    filter: Ember.inject.service(),

    modelQueryParam: '',

    init: function() {
        this._super(...arguments);

        this.set('modelQueryParam', this.get('constants').GEONAMES['world']);
    },

    model: function() {
        var filterQueryParams = _.clone(this.get('filter').get('queryParamsValues'));
        return this.store.query('geostat', _.merge(filterQueryParams, {
            'area': this.get('modelQueryParam'),
            'details': 1
        }));
    },

    activate: function() {
        this.get('player').set('window', false);
    },

    deactivate: function () {
        this.set('modelQueryParam', this.get('constants').GEONAMES['world']);
    },

    setupController: function(controller) {
        this._super(...arguments);
        controller.set('modelQueryParam', this.get('modelQueryParam'));
    },

    actions: {
        setModelQueryParam: function(id) {
            this.set('modelQueryParam', id);
            this.refresh();
        }
    }

});
