import Ember from 'ember';

export default Ember.Controller.extend({
  queryParams: ['location', 'langue', 'discours', 'date', 'thematique', 'detail'],
  location: null,
  langue: null,
  discours: null,
  date: [],
  thematique: null,
  detail: null,

  currentId: null,
  currentItem: Ember.computed('currentId', function() {
    Ember.$(".result-item").toggleClass("playing", false);
    if (this.get('currentId') === null){
      return null;
    }
    Ember.$("#"+this.get('currentId').replace( /(:|\.|\[|\]|,)/g, "\\$1" )).toggleClass("playing", true);
    return this.store.findRecord('document', this.get('currentId'));
  }),
  modalItem: Ember.computed('detail', function() {
    return this.store.findRecord('document', this.get('detail'));
  }),
  filteredDocuments: Ember.computed('location', 'langue', 'discours', 'date', 'thematique', 'model', function() {
    var location = this.get('location');
    var langue = this.get('langue');
    var discours = this.get('discours');
    var date = this.get('date');
    var thematique = this.get('thematique');

    var documents = this.get('model');

    if (location) {
      documents = documents.filterBy('spatial', location);
    }
    if (langue) {
      documents = documents.filterBy('language', langue);
    }
    if (discours) {
      documents = documents.filterBy('type', discours);
    }
    if (date.length > 0) {
      var temp = documents;
      documents.map(function(elt){
        if (date.indexOf(elt.get('created')) === -1){
          temp = temp.without(elt);
        }
      });
      documents = temp;
    }
    if (thematique) {
      documents = documents.filterBy('thematique', thematique);
    }
    return documents;
  }),
  actions: {
    deleteTag: function(query, item){
      var newParams = null;

      if (query === 'date'){
        newParams = [];
        Ember.$.each(this.get('date'), function(index, elt){
          if (elt !== item){
            newParams.push(elt);
          }
        });
      }

      this.set(query, newParams);
    },
    changeDocument: function(docDirection){
      var direction = (docDirection === "next") ? 1 : -1;
      var currentObject = this.get("filteredDocuments").findBy('id', this.get("currentItem").get('id'));
      if ( currentObject !== 'undefined'){
        var index = this.get("filteredDocuments").indexOf(currentObject);
          if ( typeof(this.get("filteredDocuments").objectAt(index+direction)) !== 'undefined'){
            return this.set('currentId', this.get("filteredDocuments").objectAt(index+direction).id);
          }
      }
      return this.set('currentId', this.get('filteredDocuments').get('firstObject').id);
    },
    play: function(item){
      this.set("currentId", item.id);
    },
    showMore: function(item){
      var domItem = Ember.$("#"+item.id.replace( /(:|\.|\[|\]|,)/g, "\\$1" ));
      if (domItem.hasClass("show-more")){
          domItem.toggleClass("show-more", false);
      } else{
        Ember.$(".result-item").toggleClass("show-more", false);
        domItem.toggleClass("show-more", true);
      }
    },
    toggleModal: function(item){
      if (typeof(item) !== 'undefined'){
        this.set("detail", item.id);
      } else {
        this.set("detail", null);
      }
    }
  }
});
