import Ember from 'ember';

export default Ember.Route.extend({
  options: Ember.inject.service(),
  model(params) {
    return this.store.findRecord('document', params.doc_id);
  },
  actions: {
    saveDocument: function(doc) {
      doc.save();
      if(this.get('options').backurl) {
        window.location.replace(this.get('options').backurl);
      }
      else {
        this.transitionTo('index');
      }
    },
    cancelDocument: function(doc) {
      doc.rollbackAttributes();
      doc.reload();
    }
  }
});
