import DS from 'ember-data';
import Ember from 'ember';
import _ from 'lodash/lodash';

export default DS.Model.extend({

    uri: DS.attr('string'),
    issued: DS.attr('date'),
    title: DS.attr('string'),
    language: DS.attr('string'),
    duration_ms: DS.attr('number', {
        defaultValue: function() {
            var self = this;
            var duration = 0;
            Object.keys(this.get('mediaArray')).forEach(function(key) {
                if (!duration && self.get('mediaArray')[key].extent_ms) {
                    duration = self.get('mediaArray')[key].extent_ms;
                }
            });
            return duration;
        }
    }),
    publisher: DS.attr('string'),
    publishers: DS.attr({ defaultValue: function() { return []; } }),
    contributors: DS.attr({ defaultValue: function() { return []; } }),
    geoInfo: DS.attr({ defaultValue: function() { return {}; } }),
    mediaArray: DS.attr({ defaultValue: function() { return []; } }),

    mediaList: Ember.computed('mediaArray', function() {
        var res = [];
        var mp3 = null;
        _.forEach(this.get('mediaArray'), function(m) {
            if(m.format === 'audio/mpeg') {
                mp3 = m;
            } else if(m.format.startsWith('audio/')) {
                res.push(m);
            }
        });
        if(mp3) {
            res.unshift(mp3);
        }
        return res;
    }),

    duration: Ember.computed('duration_ms', function() {
        return this.get('duration_ms')/1000;
    }),

    publishers_disp: Ember.computed('publisher', 'publishers', function() {
        return this.get('publisher')?this.get('publisher'):this.get('publishers').join(', ');
    })

});
