<?php
namespace CorpusParole\Libraries;

use EasyRdf\Literal;
use EasyRdf\Resource;

/**
 * Utilities functions
 */
class Utils {

    /**
     * convert DateIntervals to milliseconds
     * Months and year calculated by approximation based on average number
     * of days over 4 years (365*4+1)
     * @param \DateInterval $di the date interval
     * @return the number of milliseconds or 0 if $di is null
     */
    public static function dateIntervalToMillis(\DateInterval $di) {
        if(is_null($di)) {
            return null;
        }
        $seconds = ($di->s)
         + ($di->i * 60)
         + ($di->h * 60 * 60)
         + ($di->d * 60 * 60 * 24)
         + ($di->m * (365*4+1)/48*60*60*24)
         + ($di->y * (365*4+1)/4*60*60*24);
        return $seconds*1000;
    }

    /**
     * convert iso8601 strings to milliseconds
     * Months and year calculated by approximation based on average number
     * of days over 4 years (365*4+1)
     *
     * @param str iso8601 string
     * @return the number of milliseconds or 0 if $str is null
     */
    public static function iso8601IntervalToMillis($str) {
        if(is_null($str)) {
            return null;
        }
        elseif( $str === '') {
            return 0;
        }

        $di = new \DateInterval($str);
        return self::dateIntervalToMillis($di);
    }

    /*
     * From http://www.thecave.info/php-get-mime-type-from-file-extension/
     */
    public static function getMimetype($file) {

        // our list of mime types
        $mime_types = array(
                "pdf"=>"application/pdf",
                "exe"=>"application/octet-stream",
                "zip"=>"application/zip",
                "docx"=>"application/msword",
                "doc"=>"application/msword",
                "xls"=>"application/vnd.ms-excel",
                "ppt"=>"application/vnd.ms-powerpoint",
                "gif"=>"image/gif",
                "png"=>"image/png",
                "jpeg"=>"image/jpg",
                "jpg"=>"image/jpg",
                "mp3"=>"audio/mpeg",
                "wav"=>"audio/x-wav",
                "mpeg"=>"video/mpeg",
                "mpg"=>"video/mpeg",
                "mpe"=>"video/mpeg",
                "mov"=>"video/quicktime",
                "avi"=>"video/x-msvideo",
                "3gp"=>"video/3gpp",
                "css"=>"text/css",
                "jsc"=>"application/javascript",
                "js"=>"application/javascript",
                "php"=>"text/html",
                "htm"=>"text/html",
                "html"=>"text/html",
                "mp4"=>"video/mp4",
                "ogg"=>"video/ogg",
                "xml"=>"application/xml",
                "xhtml"=>"application/xhtml+xml",
        );

        $split_ext = explode('.',$file);
        $extension = strtolower(end($split_ext));

        return $mime_types[$extension];
    }

    public static function processLiteralResourceOrString($val) {
        if(is_null($val)) {
            return $val;
        }
        if($val instanceof Literal) {
            return $val->getValue();
        }
        elseif ($val instanceof Resource) {
            return $val->getUri();
        }
        else {
            return (string)$val;
        }
    }


}
