import Ember from 'ember';
import ENV from '../config/environment';
import SocialShareKit from 'socialsharekit';

export default Ember.Component.extend({

    classNames: ['playlist-component'],

    filter: Ember.inject.service(),
    player: Ember.inject.service(),

    isLoading: false,

    rootURL: ENV.rootURL,

    model: [],
    documents: Ember.computed('model', 'filter.location', 'filter.language', 'filter.discourse', 'filter.date', 'filter.theme', function() {
        return this.get('model');
    }),

    documentsLoaded: Ember.observer('documents', function() {
        this.get('player').set('items', this.get('documents').map(function(document) {
            return document.get('id');
        }));
        if(this.get('player').get('items').length && this.get('player').get('playing') === false) {
            this.get('player').set('item', this.get('player').get('items')[0]);
        }
    }).on('init'),

    playerItemObserver: Ember.observer('player.item', function() {
        if(this.$() && this.get('player').get('item')) {
            var ul = this.$().find('ul');
            var li = this.$().find('li#' + this.get('player').get('item').replace('.', '\\.').replace('/', '\\/'));
            if(li.length) {
                if(li.offset().top - ul.offset().top < 0) {
                    ul.animate({
                        'scrollTop': ul.scrollTop() + li.offset().top - ul.offset().top
                    });
                } else if(li.offset().top + li.outerHeight() - ul.offset().top > ul.outerHeight()) {
                    ul.animate({
                        'scrollTop': ul.scrollTop() + li.offset().top  + li.outerHeight() - ul.offset().top  - ul.height()
                    });
                }
            }
        }
    }),

    didRender: function() {
        this._super(...arguments);
        this.$().find('ul').height(Ember.$('.corpus-app-wrapper').outerHeight() - (Ember.$('.filter-component').outerHeight() + this.$().find('h2').outerHeight()));
    },

    actions: {

        previous: function() {
            this.sendAction('pageAction', 'previous');
        },

        next: function() {
            this.sendAction('pageAction', 'next');
        },

        select: function(id) {
            this.get('player').select(id);
            this.get('player').displayMetadata('notice');
        },

        play: function(id) {
            this.get('player').play(id);
        },

        pause: function() {
            this.get('player').pause();
        },

        displayTranscript: function() {
            this.get('player').displayAdditionalInformation('transcript');
        },

        displayNotice: function() {
            if(this.get('player').get('window') !== 'notice') {
                this.get('player').displayMetadata('notice');
            } else {
                this.get('player').displayMetadata(false);
            }
        },

        shareLinkRender: (elemId) => {
            //Ember.$("#"+elemId+" .playlist-share-button").click(function(e) { e.preventDefault(); return false;});
            //console.log("RENDER");
            SocialShareKit.init({selector: "#"+elemId+" .ssk"});
            Ember.$("#"+elemId+" .playlist-share-button-close").click(function() {
                // This is done like this because I was not able to register an action directly on the button like shgown on ember-tooltips documentaion (https://github.com/sir-dunxalot/ember-tooltips#popover-on-element)
                Ember.$("#corpus-app").click();
            });
            return true;
        },

        shareLinkShow: (elemId) => {
            let input = Ember.$("#"+elemId+" input");
            input.get(0).setSelectionRange(0, input.val().length);
            input.get(0).select(0, input.val().length);
            return true;
        },

        shareLinkClose: function() {
            console.log("CLOSE");
            //console.log("CLOSE", popover);
            // popover.hide();
            // return false;
        }
    }

});
