<?php

namespace CorpusParole\Http\Controllers\Api;

use Illuminate\Http\Request;

use CorpusParole\Http\Requests;
use CorpusParole\Http\Controllers\Controller;
use Es;
use Log;

class GeoStatsController extends Controller
{
    /**
     * Display the specified resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $area = $request->input('area');
        $filter = [
            'match_all' => []
        ];
        if(!is_null($area) && $area !== config('corpusparole.geonames_earth_geonamesid')) {
            $filter = [
                'term' => [
                    "geonames_hierarchy" => $area
                ]
            ];
        }
        $query = [
            'index' => env('ELASTICSEARCH_INDEX'),
            'body' => [
                "size" => 0,
                "query" => $filter,
                "aggs" => [
                    "geos" => [
                        "terms" => [
                            "size" => 0,
                            "field" => "geonames_hierarchy"
                        ]
                    ]
                ]
            ]
        ];
        $esRes = Es::search($query);

        $geosats = [];

        foreach($esRes['aggregations']['geos']['buckets'] as $bucket) {
            $geosats[(string)($bucket['key'])] = $bucket['doc_count'];
        }

        return response()->json(['geostats' => $geosats ]);
    }
}
