<?php

namespace CorpusParole\Http\Controllers\Api;

use Illuminate\Http\Request;
use CorpusParole\Http\Requests;
use CorpusParole\Http\Controllers\Controller;
use CorpusParole\Services\ViafResolverInterface;
use CorpusParole\Services\ViafResolverException;

class ViafController extends Controller
{
    public function __construct(ViafResolverInterface $viafResolver) {
        $this->viafResolver = $viafResolver;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id od comma separatedlist of ids
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        try {
            return response()->json(['viafids' => $this->viafResolver->getNames(explode(",", $id))]);
        } catch (ViafResolverException $e) {
            abort($e->getCode(), $e->getMessage());
        }
    }

}
