// sparql edit function

// ASK, null
const ASK_RESULT_FORMAT = [
    ["HTML", "text/html"]
];

// SELECT
const SELECT_RESULT_FORMAT = [
    ["HTML", "text/html"],
    ["SPARQL/CSV", "text/csv"],
    ["SPARQL/JSON", "application/sparql-results+json"],
    ["SPARQL/XML", "application/sparql-results+xml"],
    ["SPARQL/TSV", "text/tab-separated-values"],
    ["BINARY", "application/x-binary-rdf-results-table"]
];

// DESCRIBE,CONSTRUCT
const GRAPH_RESULT_FORMAT = [
    ["HTML", "text/html"],
    ["N-Triples", "application/n-triples"],
    ["RDF/XML", "application/rdf+xml"],
    ["Turtle", "text/turtle"],
    ["N3", "text/n3"],
    ["RDF/JSON", "application/rdf+json"],
    ["TriG", "application/trig"],
    ["N-Quads", "application/n-quads"],
    ["BinaryRDF", "application/x-binary-rdf"],
    ["TriX", "application/trix"],
    ["JSON-LD", "application/ld+json"]
];

function setOutputFormatSelect(selectElt, optionsList) {
    var keys = $.map(optionsList, function(o) { return o[0];});
    var selectedKey = $(":selected",selectElt).text();
    if(!selectedKey || $.inArray(selectedKey, keys) === -1) {
        selectedKey = "HTML";
    }
    selectElt.empty();
    var innerHtml = "";
    $.each(optionsList, function(i, o) {
        innerHtml += "<option value=\""+o[1]+"\""+ ((o[0]==selectedKey)?" selected=\"selected\" ":"") +">"+o[0]+"<options>";
    });

    selectElt.append(innerHtml);
}

var currentQueryType = null;

function updateQueryType(queryType) {
    var resultFormats = ASK_RESULT_FORMAT;
    if(currentQueryType != queryType) {
        if(queryType == "SELECT") {
            resultFormats = SELECT_RESULT_FORMAT;
        } else if (queryType == "DESCRIBE" || queryType == "CONSTRUCT") {
            resultFormats = GRAPH_RESULT_FORMAT;
        }
        setOutputFormatSelect($("#format"),resultFormats);
        currentQueryType = queryType;
    }
}

function getSubmitState(editor) {
    var parseErrors = $(".parseErrorIcon").length;
    return editor.getQueryMode() === 'query' && parseErrors == 0 && !/^\s*$/.test(editor.getValue());
}

function initSparqlEditor() {
    var yasqe = YASQE.fromTextArea($('#query').get(0), {
        sparql: {
            showQueryButton: false,
        }
    });
    yasqe.on("update", function(instance) {
        var queryType = instance.getQueryType();
        updateQueryType(queryType);
        var submitState = getSubmitState(instance);
        $("#submit-query-form").prop('disabled', !submitState );
        $("#format").prop('disabled', !submitState );
        $("#timeout").prop('disabled', !submitState );
    });

    $("#query-form").submit(function() {
        return getSubmitState(yasqe);
    });

    $("#limits-choices a").click(function(e) {
        e.preventDefault();
        $('#limit').val($(e.target).text());
    });

    $("#reset-query").click(function(e) {
        yasqe.setValue("");
    });

    $("#format").change(function(e) {
        $("#limit, #limit-btn").prop('disabled', ($(e.target).val() != "text/html") );
    });

}
