import Ember from 'ember';

export default Ember.Component.extend({
    classNames: ['player-component'],

    player: Ember.inject.service(),
    popcorn: null,

    head: 0,
    remaining: 0,

    isFirst: false,
    isLast: false,

    item: Ember.computed('player.model', function() {
        return this.get('player').get('model');
    }),

    modelLoaded: Ember.observer('player.model', function() {
        var items = this.get('player').get('items');
        var index = items.indexOf(this.get('player').get('item'));
        this.set('isFirst', index === 0);
        this.set('isLast', index === items.length - 1);
    }),

    itemLoaded: Ember.observer('player.model.mediaList', function() {
        this.get('popcorn').load();
    }),

    init: function() {
        this._super(...arguments);
        this.get('player');
    },

    didInsertElement: function() {
        this.set('popcorn', Popcorn('#popcorn-audio'));
        this.get('popcorn').on('loadeddata', Ember.run.bind(this, this.get('onUpdate')));
        this.get('popcorn').on('timeupdate', Ember.run.bind(this, this.get('onUpdate')));
        this.get('popcorn').on('play', Ember.run.bind(this, this.get('onPlay')));
        this.get('popcorn').on('pause', Ember.run.bind(this, this.get('onPause')));

        this.get('player').on('reset', Ember.run.bind(this, function(id) {
            if(this.get('player').get('item') !== id) {
                this.get('popcorn').on('loadeddata', Ember.run.bind(this, this.get('play')));
            } else {
                this.toggle();
            }
        }));
    },

    onUpdate: function() {
        var currentTime = this.get('popcorn').currentTime();
        var duration = this.get('popcorn').duration();
        this.$('.bar .value').width(currentTime * 100 / duration + '%');
        this.set('head', currentTime);
        this.set('remaining', duration - currentTime);
    },

    onPlay: function() {
        this.get('player').set('playing', true);
    },

    onPause: function() {
        this.get('player').set('playing', false);
    },

    play: function() {
        this.get('popcorn').play();
    },

    pause: function() {
        this.get('popcorn').pause();
    },

    toggle: function() {
        if(this.get('player').get('playing')) {
            this.pause();
        } else {
            this.play();
        } 
    },

    actions: {

        backward: function() {
            var index = this.get('player').get('items').indexOf(this.get('player').get('item'));
            console.log('backward', index);
        },

        forward: function() {
            var index = this.get('player').get('items').indexOf(this.get('player').get('item'));
            console.log('forward', index);
        }

    }
});
