<?php
namespace CorpusParole\Models;

use CorpusParole\Libraries\RdfModel\RdfModelResource;
use CorpusParole\Libraries\Utils;

use JsonSerializable;
use Log;


/**
 */
class TranscriptResource extends WebResource  {

    private $conformsTo = -1;
    private $rights = false;


    protected function doClearMemoizationCache() {
        $this->conformsTo = -1;
        $this->rights = false;
    }

    public function getConformsTo() {
        if($this->conformsTo === -1) {
            $conformsTo = $this->getResource("<http://purl.org/dc/terms/conformsTo>");
            $this->conformsTo = is_null($conformsTo)?null:$conformsTo->getUri();
        }

        return $this->conformsTo;
    }

    public function getRights() {
        if($this->rights === false) {
            $rightsRes = $this->getResource("<http://purl.org/dc/terms/license>");
            $this->rights = is_null($rightsRes)?null:$rightsRes->getUri();
        }
        return $this->rights;
    }


    protected function jsonSerializeExtra() {
        return [
            'conforms-to' => $this->getConformsTo(),
            'rights' => $this->getRights()
        ];
    }

}
