import Ember from 'ember';
import d3 from 'd3';
import env from 'app-client/config/environment';



export default Ember.Component.extend({

    constants: Ember.inject.service(),

    init: function() {
        this._super(...arguments);
    },

    didRender: function() {
        var self = this;
        var baseURL = env.baseURL.replace(/\/$/,"")+'/api/v1';

        d3.json(baseURL + "/discourses", function(discourses) {
            console.log(discourses);

            var width = self.$().parent().width();
            var height = self.$().parent().height();

            var bubble = d3.layout.pack()
                .sort(null)
                .size([width, height])
                .padding(33);

            var element = d3.select('#' + self.get('elementId'));

            var svg = element.append("svg")
                .attr("width", width)
                .attr("height", height)
                .attr("class", "bubble");

            var nodes = svg.selectAll(".node")
                .data(bubble.nodes(self.createNodes(discourses)))
                .enter().append("g")
                .attr("width", function(d) { return 2.5 * d.r + 'px'; })
                .attr("class", function(d) { return "node" + (!d.children ? " leaf" : ""); })
                .attr("transform", function(d) { return "translate(" + d.x + "," + d.y + ")"; })
                .style("font-size", function(d) { return Math.max(13, d.r / 2) + 'px'; });
                

            var leaf = svg.selectAll(".leaf")
                .on('click', function(d) { document.location = self.setQueryString('discours', d.name); });
            
            leaf.append("circle")
                .attr("r", function(d) { return d.r; })
                .attr("fill", function(d) { return d.fill; })
                .attr("stroke", function(d) { return "#000"; });
            
            leaf.append("text")
                .attr("dy", ".3em")
                .style("text-anchor", "middle")
                .text(function(d) { return d.name; });

            element.style("height", height + "px");
        });

        this._super(...arguments);
    },

    createNodes: function(json) {
        var self = this;
        var nodes = {};
        var children = {};

        Object.keys(json).forEach(function(key) {
            var discourse = json[key];
            var index = self.get('constants').DISCOURSES[key];
            var category = self.get('constants').DISCOURSE_CATEGORIES[index];

            children[index] = children[index] || {};
            children[index]['name'] = index;
            children[index]['children'] = children[index]['children'] || [];
            children[index]['children'].push({ "name": discourse.label, "value": discourse.count, "fill": category.fill });
        });

        nodes.children = [];
        Object.keys(children).forEach(function(key) {
            nodes.children.push(children[key]);
        });

        return nodes;
    },

    setQueryString: function(field, value) {
        var hash = document.location.href.split('?');
        var query_parameters = hash.pop();

        // Unserialize
        var parameters = [];
        query_parameters.split('&').forEach(function(parameter){
            var object = parameter.split('=');
            object[1] && (parameters[object[0]] = object[1]);
        });

        // Serialize
        var string = [];
        parameters[field] = encodeURI(value);
        Object.keys(parameters).forEach(function(key) {
            string.push(key + '=' + parameters[key]);
        });

        return hash + '?' + string.join('&');
    }
    
});
