import ENV from 'app-client/config/environment';
import _ from 'lodash/lodash';
import * as constants from 'corpus-common-addon/utils/constants';

export default function() {

    this.namespace = ENV.baseURL.replace(/\/$/,'')+'/api/v1';

    this.get('/documents');
    this.get('/documents/:id', function(db, request) {
        var docId = decodeURIComponent(request.params.id);

        return {
            'document': db.documents.find(docId)
        };
    });

    this.get('/languages', function(db) {
        var res = {};
        _.each(db.languages, function(lang) {
            res[lang.id] = lang.count;
        });
        return res;
    });

    this.get('/themes', function(db) {
        var res = {};
        _.each(db.themes, function(theme) {
            res[theme.id] = {'label': theme.label, 'count': theme.count};
        });
        return res;
    });

    this.get('/discourses', function(db) {
        var res = {};
        _.each(db.discourses, function(discourse) {
            res[discourse.id] = {'label': discourse.label, 'count': discourse.count};
        });
        return res;
    });

    this.get('/lexvo/:ids', function(db, request) {
        var langIds = decodeURIComponent(request.params.ids);
        var resMap = _.reduce(langIds.split(','), function(res, id) {
            var fullId = id;
            if(!_.startsWith(fullId, constants.LEXVO_BASE_URL)) {
                fullId = constants.LEXVO_BASE_URL + id;
            }
            var lexvoRes = db.lexvo.find(fullId);
            res[id] = lexvoRes?lexvoRes.name:null;
            return res;
        }, {});

        return {
            'lexvoids': resMap
        };

    });

    this.get('/bnf/:ids', function(db, request) {

        var bnfIds = decodeURIComponent(request.params.ids);
        var resMap = _.reduce(bnfIds.split(','), function(res, id) {
            var fullId = id;
            if(_.startsWith(fullId, constants.BNF_BASE_URL)) {
                fullId = fullId.slice(constants.BNF_BASE_URL.length);
            } else if (_.startsWith(fullId, constants.BNF_ARK_BASE_URL)) {
                fullId = fullId.slice(constants.BNF_ARK_BASE_URL.length);
            } else if (!_.startsWith(fullId, constants.BNF_ARK_BASE_ID)) {
                fullId = constants.BNF_ARK_BASE_ID + fullId;
            }
            var bnfRes = db.lexvo.find(fullId);
            res[fullId] = bnfRes?bnfRes.label:null;
            return res;
        }, {});

        return {
            'bnfids': resMap
        };

    });

}
