import Ember from 'ember';

export default Ember.Route.extend({

    constants: Ember.inject.service(),

    modelQueryParam: '',

    init: function() {
        this._super(...arguments);

        this.set('modelQueryParam', this.get('constants').GEONAMES['world']);
    },

    model: function() {
        return this.store.query('geostat', {
            'area': this.get('modelQueryParam'),
            'details': 1
        });
    },

    deactivate: function () {
        this.set('modelQueryParam', this.get('constants').GEONAMES['world']);
    },

    setupController: function(controller) {
        this._super(...arguments);
        controller.set('modelQueryParam', this.get('modelQueryParam'));
    },

    actions: {
        setModelQueryParam: function(id) {
            this.set('modelQueryParam', id);
            this.refresh();
        }
    }

});
