include sysconfig

# params
class { 'sysconfig::params': } ->

# upgrade system
class { 'sysconfig::sys_upgrade': }->

# install mariadb
class { 'sysconfig::mariadb': }

# install packages
class { 'sysconfig::packages': }->

# install apache
class { 'sysconfig::apache': }

# install php
class { 'sysconfig::php': }

# install handle
if(hiera('sysconfig::params::install_handle', true)) {
    class { 'sysconfig::handle': }
}

# install drupal
class { 'sysconfig::drupal': }

# install tomcat
class { 'sysconfig::tomcat': }

# install rdf4j
class { 'sysconfig::rdf4j': }->

# install elasticsearch
class { 'sysconfig::elasticsearch': }->

# install memcached
class { 'sysconfig::memcached': }->

# install corpus
class { 'sysconfig::corpus': }->

# mark first provision
file { "/var/lib/puppet/state/first_run":
    ensure => present
}
