import Ember from 'ember';
import _ from 'lodash/lodash';

export default Ember.Component.extend({

    colors: Ember.inject.service(),
    filter: Ember.inject.service(),

    tagName: 'li',
    classNameBindings: ['isDisabled:disabled', 'isDark:light-color', 'isHighlighted:highlighted'],
    attributeBindings: ['style', 'title', 'id'],

    colorScale: null,

    isDisabled: Ember.computed('range', 'year', 'count', function() {
        let year = parseInt(this.get('year'));
        let count = this.get('count');
        return (!_.inRange(year, this.get('range')[0], this.get('range')[1]+1)) || count === 0;
    }),

    isHighlighted: Ember.computed('filter.dateList.[]', function() {
        return _.contains(this.get('filter.dateList'), this.get('year'));
    }),
    isDark: Ember.computed('backgroundColor', 'isDisabled', function() {
        let backgroundColor = this.get('backgroundColor');
        if(this.get('isDisabled')) {
            return false;
        }
        return this.get('colors').getPerceptiveLuminance(backgroundColor) >= 0.5;
    }),

    backgroundColor: Ember.computed('count', function() {
        return this.get('scale')(this.get('count'));
        //return this.get('colors').shadeLinear(this.get('count'), this.get('minCount'), this.get('maxCount'));
    }),

    style: Ember.computed('backgroundColor', 'isDisabled', 'isHighlighted', function() {
        let backgroundColor = this.get('backgroundColor');
        if(this.get('isDisabled') || this.get('isHighlighted')) {
          return null;
        }
        return Ember.String.htmlSafe(`background-color: ${backgroundColor};`);
    }),
    id: Ember.computed.alias('year'),
    count: Ember.computed('datestats.[]', function() {
        let year = this.get('year');
        let count = this.get('datestats').get(`${year}`);
        return count?count:0;
    }),
    title: Ember.computed('count', 'isDsabled', function() {
        if(this.get('isDisabled')) {
            return null;
        }
        let year = this.get('year');
        let count = this.get('count');
        return `${year} (${count})`;
    }),

    year: null,
    datestats: null,
    range: null,
});
